<?php
// Test order creation to verify admin panel integration
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    // Create a test order
    $orderId = 'ORD-' . strtoupper(substr(md5(uniqid()), 0, 8));
    
    $sql = "INSERT INTO orders (order_id, product_id, product_name, price, quantity, total, customer_email, review_location, promo_code, reviews_per_day, file_name, file_link, customer_notes, status, order_date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending', NOW())";
    
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $product_id = 1;
        $product_name = "Google Reviews Package";
        $price = 49.99;
        $quantity = 1;
        $total = 49.99;
        $customer_email = "test@example.com";
        $review_location = "Google My Business";
        $promo_code = "";
        $reviews_per_day = 2;
        $file_name = "";
        $file_link = "";
        $customer_notes = "Test order from website";
        
        $stmt->bind_param(
            "sisddssssisss",
            $orderId,
            $product_id,
            $product_name,
            $price,
            $quantity,
            $total,
            $customer_email,
            $review_location,
            $promo_code,
            $reviews_per_day,
            $file_name,
            $file_link,
            $customer_notes
        );
        
        if ($stmt->execute()) {
            echo "<h2>✅ Test Order Created Successfully!</h2>";
            echo "<p><strong>Order ID:</strong> $orderId</p>";
            echo "<p><strong>Customer:</strong> $customer_email</p>";
            echo "<p><strong>Product:</strong> $product_name</p>";
            echo "<p><strong>Amount:</strong> $" . number_format($total, 2) . "</p>";
            echo "<p><strong>Status:</strong> Pending</p>";
            echo "<br>";
            echo "<p>This order should now appear in your admin panel!</p>";
            echo "<br>";
            echo "<a href='admin_dashboard.php' style='background: #3b82f6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>View Admin Panel</a>";
            echo "<a href='index.php' style='background: #10b981; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Back to Website</a>";
        } else {
            echo "<h2>❌ Error creating test order</h2>";
            echo "<p>Error: " . $stmt->error . "</p>";
        }
        
        $stmt->close();
    } else {
        echo "<h2>❌ Database Error</h2>";
        echo "<p>Error: " . $conn->error . "</p>";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<h2>❌ Connection Error</h2>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
}
?>

<style>
body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
h2 { color: #333; }
p { margin: 10px 0; }
</style>
